using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.SharePoint;
using Microsoft.SharePoint.WebPartPages;

using Microsoft.SharePoint.WebControls;

namespace EasyTabParts
{
	/// <summary>
	/// Description of the toolpart. Override the GetToolParts method in your Web Part
	/// class to invoke this toolpart. To establish a reference to the Web Part 
	/// the user has selected, use the ParentToolPane.SelectedWebPart property.
	/// </summary>
	public class PageBrowserToolPart: Microsoft.SharePoint.WebPartPages.ToolPart
	{
		
		/// <summary>
		/// Constructor for the class. A great place to set Set default values for
		/// additional base class properties here.
		/// <summary>

		public PageBrowserToolPart()
		{
			this.Title = "Page Browser Settings";
		}

		#region ApplyChanges - Updates web part with tool part changes

		///	<summary>
		///	Called by the tool pane to apply property changes to the selected Web Part. 
		///	</summary>
		public override void ApplyChanges()
		{
			// apply property values here
			PageBrowser pbWebPart = this.ParentToolPane.SelectedWebPart as PageBrowser;
			if (pbWebPart != null)
			{
				pbWebPart.DocumentLibrary = docLibSelector.SelectedValue;
				pbWebPart.SortColumn = sortColumnSelector.SelectedValue;
				pbWebPart.ShowHome = showHomeCheckBox.Checked;
				pbWebPart.ShowHomeTitle = homeTitleTextBox.Text;
				pbWebPart.QueryString = queryStringTextBox.Text;
				if (navStyleRBList.SelectedValue == "links")
				{
					pbWebPart.NavStyle = PageBrowser.WPStyle.Links;
				}
				else
				{
					pbWebPart.NavStyle = PageBrowser.WPStyle.Tabs;
				}
				if (navOrientationRBList.SelectedValue == "horizontal")
				{
					pbWebPart.NavOrientation = PageBrowser.WPOrientation.Horizontal;
				}
				else
				{
					pbWebPart.NavOrientation = PageBrowser.WPOrientation.Vertical;
				}
			}
		}

		#endregion

		#region SyncChanges() - Updates tool part when web part has been updated
		/// <summary>
		///	If the ApplyChanges method succeeds, this method is called by the tool pane 
		///	to refresh the specified property values in the toolpart user interface.
		/// </summary>
		public override void SyncChanges()
		{
			// sync with the new property changes here
		}

		#endregion

		#region CancelChanges() - Backs out any changes in webpart if tool part changes are cancelled

		/// <summary>
		///	Called by the tool pane if the user discards changes to the selected Web Part. 
		/// </summary>
		public override void CancelChanges()
		{
		}

		#endregion

		#region Tool Part Rendering

		// ToolPart Controls
		private Label selectorLabel;
		private DropDownList docLibSelector;
		private Label sortSelectorLabel;
		private DropDownList sortColumnSelector;
		private Label checkBoxPrefixLabel;
		private CheckBox showHomeCheckBox;
		private Label homeTitleLabel;
		private TextBox homeTitleTextBox;
		private Label styleLabel;
		private RadioButtonList navStyleRBList;
		private Label orientationLabel;
		private RadioButtonList navOrientationRBList;
		private Label queryStringLabel;
		private TextBox queryStringTextBox;

		protected override void CreateChildControls()
		{
			base.CreateChildControls ();
			PageBrowser pbWebPart = this.ParentToolPane.SelectedWebPart as PageBrowser;

			if (pbWebPart != null)
			{
				selectorLabel = new Label ();
				selectorLabel.Text = "<br>Document Library: ";
				this.Controls.Add (selectorLabel);

				docLibSelector = new DropDownList();
				SPWeb myWeb = SPControl.GetContextWeb (Context);
				SPList myPageDocLib = myWeb.Lists[0];
				foreach (SPList list in myWeb.Lists)
				{
					if (list.BaseType == SPBaseType.DocumentLibrary)
					{
						// Suppress built-in document libraries such as galleries - which do not allow deletion
						if (list.AllowDeletion)
						{
							string docLibName = list.Title;
							ListItem li = new ListItem (docLibName, docLibName);
							docLibSelector.Items.Add (li);
							if (li.Value == pbWebPart.DocumentLibrary)
							{
								li.Selected = true;
								myPageDocLib = myWeb.Lists [li.Value];
							}
						}
					}
				}
				this.Controls.Add (docLibSelector);

				sortSelectorLabel = new Label();
				sortSelectorLabel.Text = "<br>Sort Column: ";
				this.Controls.Add (sortSelectorLabel);

				sortColumnSelector = new DropDownList();
				foreach (SPField field in myPageDocLib.Fields)
				{
					if (!IsHiddenField (field))
					{
						string fieldName = field.Title;
						string fieldInternalName = field.InternalName;
						ListItem li = new ListItem (fieldName, fieldInternalName);
						sortColumnSelector.Items.Add (li);
						if (li.Value == pbWebPart.SortColumn)
						{
							li.Selected = true;
						}
					}
				}
				this.Controls.Add (sortColumnSelector);

				checkBoxPrefixLabel = new Label();
				checkBoxPrefixLabel.Text = "<br>";
				this.Controls.Add (checkBoxPrefixLabel);

				showHomeCheckBox = new CheckBox();
				showHomeCheckBox.Text = "Show Link to Main Page";
				showHomeCheckBox.Checked = pbWebPart.ShowHome;
				this.Controls.Add (showHomeCheckBox);

				homeTitleLabel = new Label();
				homeTitleLabel.Text = "<br>Title for Main Page: ";
				this.Controls.Add (homeTitleLabel);

				homeTitleTextBox = new TextBox();
				homeTitleTextBox.Text = pbWebPart.ShowHomeTitle;
				this.Controls.Add (homeTitleTextBox);

				styleLabel = new Label();
				styleLabel.Text = "Navigation Style";
				this.Controls.Add (styleLabel);

				navStyleRBList = new RadioButtonList();
				navStyleRBList.Items.Add (new ListItem ("Links", "links"));
				navStyleRBList.Items.Add (new ListItem ("Tabs", "tabs"));
				if (pbWebPart.NavStyle == PageBrowser.WPStyle.Links)
				{
					navStyleRBList.SelectedIndex = 0;
				}
				else
				{
					navStyleRBList.SelectedIndex = 1;
				}
				this.Controls.Add (navStyleRBList);

				orientationLabel = new Label();
				orientationLabel.Text = "Orientation";
				this.Controls.Add (orientationLabel);

				navOrientationRBList = new RadioButtonList();
				navOrientationRBList.Items.Add (new ListItem ("Horizontal", "horizontal"));
				navOrientationRBList.Items.Add (new ListItem ("Vertical", "vertical"));
				if (pbWebPart.NavOrientation == PageBrowser.WPOrientation.Horizontal)
				{
					navOrientationRBList.SelectedIndex = 0;
				}
				else
				{
					navOrientationRBList.SelectedIndex = 1;
				}
				this.Controls.Add (navOrientationRBList);

				queryStringLabel = new Label();
				queryStringLabel.Text = "Query String for Connected Data:<br>";
				this.Controls.Add (queryStringLabel);

				queryStringTextBox = new TextBox();
				queryStringTextBox.Text = pbWebPart.QueryString;
				this.Controls.Add (queryStringTextBox);
			}
		}

		bool IsHiddenField (SPField field)
		{
			// Note - we use the internal names so this will work with non-English language packs
			string [] hiddenFieldNames = {"Created", "Author", "Modified", "Editor", "_ModerationStatus", "_ModerationComments",
											 "FileRef", "FileDirRef", "Last_x0020_Modified", "Created_x0020_Date", "File_x0020_Size",
											 "FSObjType", "CheckedOutUserId", "FileLeafRef", "VirusStatus", "CheckedOutTitle",
											 "LinkCheckedOutTitle", "Modified_x0020_By", "Created_x0020_By", "owshiddenversion",
											 "File_x0020_Type", "HTML_x0020_File_x0020_Type", "_SourceUrl", "_SharedFileIndex", "EncodedAbsUrl",
											 "LinkFilenameNoMenu", "LinkFilename", "SelectTitle", "SelectFilename", "Edit",
											 "DocIcon", "ServerUrl", "EncodeAbsUrl", "BaseName", "FileSizeDisplay", "InstanceID",
											 "Order"};
																	;
			string fieldName = field.InternalName;

			for (int i=hiddenFieldNames.GetLowerBound(0); i<=hiddenFieldNames.GetUpperBound(0); i++)
			{
				if (fieldName == hiddenFieldNames[i])
				{
					return (true);
				}
			}
			return (false);
		}

		/// <summary>
		/// Render this Tool part to the output parameter specified.
		/// </summary>
		/// <param name="output"> The HTML writer to write out to </param>
//		protected override void RenderToolPart(HtmlTextWriter output)
//		{
//		}

		#endregion

	}											
}
								
